-- PaneDisplay.
-- shows up when SSMusicInfo is set to PaneDisplay.

local pd = Def.ActorFrame{
	Name="PaneDisplaySection";
	InitCommand=cmd(x,-64);
};

-- player stuff is out back

local numPlayers = GAMESTATE:GetNumSidesJoined();
local panes = Def.ActorFrame{ }; -- panes!!
local rv;

local headerWidth = 240;
if numPlayers == 2 then
	headerWidth = (headerWidth / 2)-2;
end;

local paneCategories = {
	'RadarCategory_TapsAndHolds',
	'RadarCategory_Jumps',
	'RadarCategory_Holds',
	'RadarCategory_Mines',
	'RadarCategory_Hands',
	'RadarCategory_Rolls'
};

local paneStrings = {
	THEME:GetString("PaneDisplay","Steps"),
	THEME:GetString("PaneDisplay","Jumps"),
	THEME:GetString("PaneDisplay","Holds"),
	THEME:GetString("PaneDisplay","Mines"),
	THEME:GetString("PaneDisplay","Hands"),
	THEME:GetString("PaneDisplay","Rolls")
};

local paneColors = {
	cRed, cOrange, cYellow, cGreen, cBlue, cPurple
};

if numPlayers == 1 then
	-- single player
	local player = GAMESTATE:GetMasterPlayerNumber();
	
	panes[#panes+1] = Def.ActorFrame{
		Name="Frame"..player;
		InitCommand=cmd(x,80);
		
		LoadActor( THEME:GetPathB("","_frame 3x3"), "Pref", headerWidth-2, 80)..{
			InitCommand=cmd(diffuse,PlayerColor(player);y,56-8);
		};
		
		LoadFont("Common Normal")..{
			InitCommand=cmd(NoStroke;shadowlength,1;zoom,0.55;y,-2);
			BeginCommand=function(self)
				local str;
				if player == PLAYER_1 then str = "P1 Information";
				else str = "P2 Information";
				end;
				self:settext(str);
			end;
		};
	};
	
	for i=1,#paneCategories do
		panes[#panes+1] = Def.ActorFrame{
			Name=player..paneStrings[i];
			InitCommand=cmd(y,(i)*16);
			
			LoadFont("Common Normal")..{
				Text=paneStrings[i];
				InitCommand=cmd(NoStroke;shadowlength,1;horizalign,right;zoom,0.55;diffuse,BoostColor(paneColors[i],1.75));
			};
			
			LoadFont("Common Normal")..{
				InitCommand=cmd(x,8;NoStroke;shadowlength,1;horizalign,left;zoom,0.55;playcommand,"Set");
				
				SetCommand=function(self)
					local song;
					local steps;
					if GAMESTATE:IsCourseMode() then
						song = GAMESTATE:GetCurrentCourse();
						steps = GAMESTATE:GetCurrentTrail(player);
					else
						song = GAMESTATE:GetCurrentSong();
						steps = GAMESTATE:GetCurrentSteps(player);
					end;
					
					if not song then self:visible(false);
					else self:visible(true);
					end;
					
					if steps then
						rv = steps:GetRadarValues(player);
						local val = rv:GetValue(paneCategories[i]);
						self:settext( val );
						if val == 0 then
							self:diffusealpha(0.5);
						else
							self:diffusealpha(1);
						end;
					else
						self:settext("");
					end;
				end;
				
				CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
				CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
				
				CurrentStepsP1ChangedMessageCommand=function(self)
					if player == PLAYER_1 then self:playcommand("Set"); end;
				end;
				CurrentTrailP1ChangedMessageCommand=function(self)
					if player == PLAYER_1 then self:playcommand("Set"); end;
				end;
				CurrentStepsP2ChangedMessageCommand=function(self)
					if player == PLAYER_2 then self:playcommand("Set"); end;
				end;
				CurrentTrailP2ChangedMessageCommand=function(self)
					if player == PLAYER_2 then self:playcommand("Set"); end;
				end;
			};
		};
	end;
else
	-- two players
	
	for pi, pname in pairs(PlayerNumber) do
		panes[#panes+1] = Def.ActorFrame{
			Name="Frame"..pname;
			InitCommand=function(self)
				if pname == PLAYER_1 then self:x(8);
				else self:x(152);
				end;
			end;
			
			LoadActor( THEME:GetPathB("","_frame 3x3"), "Pref", headerWidth-20, 80)..{
				InitCommand=cmd(diffuse,PlayerColor(pname);y,56-8);
			};
			
			LoadFont("Common Normal")..{
				InitCommand=cmd(NoStroke;shadowlength,1;zoom,0.55;y,-2);
				BeginCommand=function(self)
					local str;
					if pname == PLAYER_1 then str = "P1 Information";
					else str = "P2 Information";
					end;
					self:settext(str);
				end;
			};
		};
		
		for i=1,#paneCategories do
		panes[#panes+1] = Def.ActorFrame{
			Name=pname..paneStrings[i];
			InitCommand=cmd(y,(i)*16);
			
			LoadFont("Common Normal")..{
				Text=paneStrings[i];
				InitCommand=cmd(NoStroke;shadowlength,1;horizalign,right;zoom,0.55;diffuse,BoostColor(paneColors[i],1.75));
				BeginCommand=function(self)
					if pname == PLAYER_1 then self:x(0);
					else self:x(144);
					end;
				end;
			};
			
			LoadFont("Common Normal")..{
				InitCommand=cmd(NoStroke;shadowlength,1;horizalign,left;zoom,0.55;playcommand,"Set");
				BeginCommand=function(self)
					if pname == PLAYER_1 then self:x(8);
					else self:x(152);
					end;
				end;
				
				SetCommand=function(self)
					local song;
					local steps;
					if GAMESTATE:IsCourseMode() then
						song = GAMESTATE:GetCurrentCourse();
						steps = GAMESTATE:GetCurrentTrail(pname);
					else
						song = GAMESTATE:GetCurrentSong();
						steps = GAMESTATE:GetCurrentSteps(pname);
					end;
					
					if not song then self:visible(false);
					else self:visible(true);
					end;
					
					if steps then
						rv = steps:GetRadarValues(pname);
						local val = rv:GetValue(paneCategories[i]);
						self:settext( val );
						if val == 0 then
							self:diffusealpha(0.5);
						else
							self:diffusealpha(1);
						end;
					else
						self:settext("");
					end;
				end;
				
				CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
				CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
				
				CurrentStepsP1ChangedMessageCommand=function(self)
					if pname == PLAYER_1 then self:playcommand("Set"); end;
				end;
				CurrentTrailP1ChangedMessageCommand=function(self)
					if pname == PLAYER_1 then self:playcommand("Set"); end;
				end;
				CurrentStepsP2ChangedMessageCommand=function(self)
					if pname == PLAYER_2 then self:playcommand("Set"); end;
				end;
				CurrentTrailP2ChangedMessageCommand=function(self)
					if pname == PLAYER_2 then self:playcommand("Set"); end;
				end;
			};
		};
	end;
	end;
end;

pd[#pd+1] = panes;

return pd;